/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.file;

import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.fmteditor.file.LoaderSaver;
import com.quantumdata.fmteditor.report.FmtReport;
import com.quantumdata.fmteditor.report.FmtReportFrame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FmtReportLoader
extends LoaderSaver {
    protected FmtReport m_summary;

    protected void localLoad() {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.m_file));
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            if (object instanceof FmtReport) {
                this.m_summary = (FmtReport)object;
                this.m_summary.setFileName(this.m_file.getAbsolutePath());
                this.m_success = true;
                this.m_frame = new FmtReportFrame(this.m_summary);
            } else {
                this.m_errMsg = "Invalid file type";
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_errMsg = fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            this.m_errMsg = iOException.getMessage();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.m_errMsg = "Invalid file type";
        }
        this.callLoadComplete();
    }

    protected void localSave() {
        try {
            FmtReportFrame fmtReportFrame = (FmtReportFrame)this.m_frame;
            String string = this.m_file.getAbsolutePath();
            if (!string.toLowerCase().endsWith(FmtFileType.REPORT.extension())) {
                string = string + FmtFileType.REPORT.extension();
                this.m_file = new File(string);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.m_file)));
            fmtReportFrame.captureReport();
            objectOutputStream.writeObject(fmtReportFrame.getData());
            objectOutputStream.close();
            fmtReportFrame.markUnmodified();
            fmtReportFrame.getData().setFileName(this.m_file.getAbsolutePath());
            this.m_success = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_errMsg = fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            this.m_errMsg = iOException.getMessage();
        }
        this.callSaveComplete();
    }

    protected void remoteLoad() {
        this.m_errMsg = "Remote load Operation not supported";
        this.callLoadComplete();
    }

    protected void remoteSave() {
        this.m_errMsg = "Remote save Operation not supported";
        this.callSaveComplete();
    }
}

